function [mk] = mk_Sistema(nizSSS, nizMKS, ssv, ssk)
% Odredjivanje matrice krutosti
% nizSSS - niz nizova stepeni slobode stapova
% nizMKS - niz matrica krutosti stapova u GKS
% ssv - kodni brojevi stepeni slobode vrsta matrice sistema u GKS
% ssk - kodni brojevi stepeni slobode kolona matrice sistema u GKS

%Prazna matrica sistema
MK=zeros(length(ssv),length(ssk));

%Prolazi se kroz niz nizova kodnih brojeva stapova
for m=1:1:length(nizSSS)
    %Ucita se niz kodnih brojeva stapa iz niza nizova kodnih brojeva stapova
    SSstap=nizSSS{m};
    %Prolazi se kroz niz kodnih brojeva stapa
    for i=1:1:length(SSstap)
        %Prolazi se kroz niz kodnih brojeva vrsta matrice sistema
        for j=1:1:length(ssv)
            %Ako je kodni broj stapa jednak kodnom broju vrste matrice sistema
            if SSstap(i)==ssv(j)
                %Prolazi se kroz niz kodnih brojeva stapa
                for k=1:1:length(SSstap)
                    %Prolazi se kroz niz kodnih brojeva kolona matrice sistema
                    for n=1:1:length(ssk)
                        %Ako je kodni broj stapa jednak kodnom broju kolone matrice sistema
                        if SSstap(k)==ssk(n)
                            temp_MK = nizMKS{m};
                            MK(j,n)=MK(j,n)+temp_MK(i,k);
                        end
                    end
                end
            end
        end
    end
end

% Moze i na nacin ispod
% for i=1:1:length(ssv)
%     kbVrste=ssv(i);
%     for j=1:1:length(ssk)
%         kbKolone=ssk(j);
%         for k=1:1:length(nizSSS)
%             SSstap=nizSSS{k};
%             for m=1:1:length(SSstap)
%                 if kbVrste==SSstap(m)
%                     for n=1:1:length(SSstap)
%                         if kbKolone==SSstap(n)
%                             temp_MK = nizMKS{k};
%                             MK(i,j)=MK(i,j)+temp_MK(m,n);
%                         end
%                     end
%                 end
%             end
%         end
%     end
% end

%Povratna vrednost
mk=MK;
